<?php $__env->startSection('content'); ?>
    <style>
        body {
            background: linear-gradient(135deg, #3f87a6, #ebf8e1);
            font-family: 'Poppins', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .login-card {
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            width: 400px;
            padding: 2rem;
            transition: all 0.3s ease;
        }

        .login-card:hover {
            transform: translateY(-5px);
        }

        .login-logo img {
            height: 60px;
            margin-bottom: 1rem;
        }

        .login-header {
            text-align: center;
            margin-bottom: 1.5rem;
        }

        .login-header h3 {
            font-weight: 600;
            color: #333;
            margin-top: 0.5rem;
        }

        .form-control {
            border-radius: 10px;
            padding: 0.75rem;
            font-size: 15px;
        }

        .btn-primary {
            border-radius: 10px;
            background: linear-gradient(135deg, #007bff, #00bcd4);
            border: none;
            transition: background 0.3s ease;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #0056b3, #0097a7);
        }

        .login-footer {
            text-align: center;
            margin-top: 1rem;
        }

        .login-footer a {
            color: #007bff;
            text-decoration: none;
        }

        .login-footer a:hover {
            text-decoration: underline;
        }

        .input-group-text {
            border-radius: 10px 0 0 10px;
            background: #f0f0f0;
        }

        .form-group {
            position: relative;
        }
    </style>

    <div class="login-card">
        <div class="login-header">
            <div class="login-logo">
                <a href="<?php echo e(route('admin.home')); ?>">
                    
                    <img src="<?php echo e(url('/images/logo-light.png')); ?>" alt="BlueWeldSG Logo" class="logo-image" width="90"
                        height="auto">
                </a>
            </div>
            <h3><?php echo e(trans('global.reset_password')); ?></h3>
            <p class="text-muted">Enter your email to receive password reset instructions.</p>
        </div>

        <?php if(session('status')): ?>
            <div class="alert alert-success text-center" role="alert">
                <?php echo e(session('status')); ?>

            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('password.email')); ?>">
            <?php echo csrf_field(); ?>

            <div class="form-group mb-3">
                <div class="input-group">
                    <span class="input-group-text"><i class="fa fa-envelope"></i></span>
                    <input id="email" type="email"
                        class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" name="email"
                        value="<?php echo e(old('email')); ?>" required placeholder="<?php echo e(trans('global.login_email')); ?>" autofocus>
                </div>
                <?php if($errors->has('email')): ?>
                    <div class="invalid-feedback d-block"><?php echo e($errors->first('email')); ?></div>
                <?php endif; ?>
            </div>

            <button type="submit" class="btn btn-primary w-100 py-2">
                <i class="fa fa-paper-plane"></i> <?php echo e(trans('global.send_password')); ?>

            </button>
        </form>

        <div class="login-footer">
            <p class="mt-3 text-muted">
                <a href="<?php echo e(route('login')); ?>">
                    <i class="fa fa-arrow-left"></i> Back to login
                </a>
            </p>
            <p class="text-muted">&copy; <?php echo e(date('Y')); ?> <?php echo e(app_name()); ?></p>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Alphinex Solutions\blueweldsg-royce\resources\views/auth/passwords/email.blade.php ENDPATH**/ ?>