<?php $__env->startSection('title', 'Contact Us - BlueWeldSG | Get Your Free Quotation Today'); ?>

<?php $__env->startSection('content'); ?>

    <!-- Hero Section -->
    <section class="hero hero-with-image hero-contact">
        <div class="hero-background"></div>
        <div class="hero-overlay"></div>
        <div class="hero-container">
            <div class="hero-badge">Get In Touch</div>
            <h1>Contact Us for<br>Free Quotation</h1>
            <p class="hero-subtitle">
                Ready to start your project? Reach out to us for expert advice and a free, no-obligation quotation
                for your stainless steel welding needs.
            </p>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="section bg-white">
        <div class="container">
            <!-- Main Contact Cards - Equal Height -->
            <div class="contact-main-grid">
                <!-- Contact Form -->
                <div class="contact-form-card">
                    <div class="contact-form-header">
                        <div class="contact-form-header-icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M20 4H4C2.9 4 2.01 4.9 2.01 6L2 18C2 19.1 2.9 20 4 20H20C21.1 20 22 19.1 22 18V6C22 4.9 21.1 4 20 4ZM20 8L12 13L4 8V6L12 11L20 6V8Z"
                                    fill="currentColor" />
                            </svg>
                        </div>
                        <h3>Send Us a Message</h3>
                        <p style="color: #1e293b; font-weight: 500;">Fill out the form below and we'll get back to you soon
                        </p>
                    </div>

                    <div class="contact-form-content">
                        <form id="contactForm" class="contact-form" method="POST" action="<?php echo e(route('contact.submit')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label class="form-label">Your Name <span style="color: red;">*</span></label>
                                <input type="text" name="name" required
                                    class="form-input <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('name')); ?>">
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-message"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label class="form-label">Email Address <span style="color: red;">*</span></label>
                                <input type="email" name="email" required
                                    class="form-input <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('email')); ?>">
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-message"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label class="form-label">Phone Number <span style="color: red;">*</span></label>
                                <input type="tel" name="phone" class="form-input <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    value="<?php echo e(old('phone')); ?>">
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-message"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label class="form-label">Service Required <span style="color: red;">*</span></label>
                                <select class="form-input" name="service">
                                    <option value="Cold Welding" <?php echo e(old('service') == 'Cold Welding' ? 'selected' : ''); ?>>
                                        Cold Welding</option>
                                    <option value="Fabrication" <?php echo e(old('service') == 'Fabrication' ? 'selected' : ''); ?>>
                                        Fabrication</option>
                                    <option value="Onsite Services"
                                        <?php echo e(old('service') == 'Onsite Services' ? 'selected' : ''); ?>>Onsite Services</option>
                                    <option value="Custom Solutions"
                                        <?php echo e(old('service') == 'Custom Solutions' ? 'selected' : ''); ?>>Custom Solutions
                                    </option>
                                    <option value="Other" <?php echo e(old('service') == 'Other' ? 'selected' : ''); ?>>Other</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label class="form-label">Message <span style="color: red;">*</span></label>
                                <textarea name="message" required rows="4" class="form-input <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('message')); ?></textarea>
                                <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-message"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <button type="submit" id="submitButton" class="btn btn-primary contact-submit-btn">
                                <span id="buttonText">Send Message</span>
                                <span id="buttonLoader" style="display:none;">Sending...</span>
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M7.5 15L12.5 10L7.5 5" stroke="currentColor" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Contact Information -->
                <div class="contact-info-card">
                    <div class="contact-info-header">
                        <h3>Contact Information</h3>
                        <p style="color: #1e293b; font-weight: 500;">Get in touch with us through any of these channels</p>
                    </div>

                    <div class="contact-info-list">
                        <div class="contact-info-item">
                            <div class="contact-info-row">
                                <div class="contact-info-icon location">
                                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M12 2C8.13 2 5 5.13 5 9C5 14.25 12 22 12 22S19 14.25 19 9C19 5.13 15.87 2 12 2ZM12 11.5C10.62 11.5 9.5 10.38 9.5 9S10.62 6.5 12 6.5S14.5 7.62 14.5 9S13.38 11.5 12 11.5Z"
                                            fill="currentColor" />
                                    </svg>
                                </div>
                                <h4 class="contact-info-title">Our Location</h4>
                            </div>
                            <div class="contact-info-details">
                                <p class="contact-main" style="color: #1e293b; font-weight: 600;">Singapore</p>
                                <p class="contact-sub" style="color: #475569;">Serving all areas across Singapore</p>
                            </div>
                        </div>

                        <div class="contact-info-item">
                            <div class="contact-info-row">
                                <div class="contact-info-icon email">
                                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M20 4H4C2.9 4 2.01 4.9 2.01 6L2 18C2 19.1 2.9 20 4 20H20C21.1 20 22 19.1 22 18V6C22 4.9 21.1 4 20 4ZM20 8L12 13L4 8V6L12 11L20 6V8Z"
                                            fill="currentColor" />
                                    </svg>
                                </div>
                                <h4 class="contact-info-title">Email Us</h4>
                            </div>
                            <div class="contact-info-details">
                                <p class="contact-main" style="color: #1e293b; font-weight: 600;">info@blueweldsg.com</p>
                                <p class="contact-sub" style="color: #475569;">We respond within 24 hours</p>
                            </div>
                        </div>

                        <div class="contact-info-item">
                            <div class="contact-info-row">
                                <div class="contact-info-icon hours">
                                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M12 2C6.5 2 2 6.5 2 12S6.5 22 12 22S22 17.5 22 12S17.5 2 12 2ZM17 13H11V7H12.5V11.5H17V13Z"
                                            fill="currentColor" />
                                    </svg>
                                </div>
                                <h4 class="contact-info-title">Business Hours</h4>
                            </div>
                            <div class="contact-info-details">
                                <p class="contact-main" style="color: #1e293b; font-weight: 600;">Monday - Saturday: 9:00
                                    AM - 6:00 PM</p>
                                <p class="contact-sub" style="color: #475569;">Sunday: Closed</p>
                            </div>
                        </div>
                    </div>

                    <!-- WhatsApp Card -->
                    <div class="whatsapp-contact-card"
                        style="margin-top: 1.5rem; padding: 1.5rem; background: linear-gradient(135deg, #25D366 0%, #128C7E 100%); border-radius: 12px; text-align: center;">
                        <div style="margin-bottom: 1rem;">
                            <svg width="48" height="48" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                                style="filter: drop-shadow(0 2px 4px rgba(0,0,0,0.1));">
                                <path
                                    d="M17.472 14.382C17.367 14.382 17.188 14.329 16.935 14.223C16.683 14.118 15.893 13.729 15.641 13.624C15.388 13.518 15.209 13.465 15.030 13.729C14.851 13.994 14.566 14.382 14.408 14.571C14.251 14.759 14.093 14.782 13.841 14.665C13.588 14.547 12.798 14.329 11.902 13.518C11.207 12.894 10.720 12.141 10.562 11.876C10.405 11.612 10.541 11.471 10.658 11.353C10.764 11.247 10.893 11.082 11.010 10.924C11.127 10.765 11.174 10.647 11.279 10.459C11.385 10.271 11.332 10.112 11.279 9.994C11.227 9.876 10.720 8.847 10.468 8.318C10.215 7.788 9.963 7.859 9.784 7.859C9.605 7.859 9.426 7.859 9.247 7.859C9.068 7.859 8.816 7.912 8.563 8.176C8.311 8.441 7.892 8.829 7.892 9.859C7.892 10.888 8.616 11.876 8.733 12.065C8.851 12.253 10.720 15.141 13.588 16.047C14.251 16.329 14.777 16.494 15.188 16.612C15.851 16.824 16.462 16.788 16.935 16.729C17.472 16.659 18.104 16.329 18.262 15.953C18.419 15.576 18.419 15.247 18.367 15.176C18.314 15.106 18.135 15.053 17.883 14.935C17.630 14.818 17.472 14.382 17.472 14.382Z"
                                    fill="white" />
                                <path
                                    d="M12.541 18.824H12.541C10.877 18.824 9.247 18.365 7.840 17.506L7.521 17.318L4.668 18.118L5.468 15.341L5.259 15.012C4.347 13.576 3.868 11.918 3.868 10.188C3.868 5.624 7.521 1.971 12.085 1.971C14.304 1.971 16.409 2.824 18.052 4.467C19.695 6.110 20.548 8.215 20.548 10.434C20.548 14.998 16.895 18.651 12.331 18.651L12.541 18.824Z"
                                    fill="white" />
                            </svg>
                        </div>
                        <h4 style="color: white; font-size: 1.25rem; font-weight: 700; margin-bottom: 0.5rem;">Chat with Us
                            on WhatsApp</h4>
                        <p style="color: rgba(255,255,255,0.9); margin-bottom: 1.25rem; font-size: 0.95rem;">Get instant
                            responses to your queries</p>
                        <a href="https://wa.me/6591836610" class="btn-whatsapp-main"
                            style="display: inline-block; padding: 0.75rem 2rem; background: white; color: #25D366; border-radius: 8px; text-decoration: none; font-weight: 700; font-size: 1rem; box-shadow: 0 4px 6px rgba(0,0,0,0.1); transition: transform 0.2s;">
                            <i class="fab fa-whatsapp" style="margin-right: 0.5rem; font-size: 1.25rem;"></i>Start Chat
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- FAQ Section -->
    <section class="section bg-light">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">FAQs</span>
                <h2 class="section-title">Frequently Asked Questions</h2>
            </div>

            <div style="max-width: 800px; margin: 0 auto;">
                <div class="card" style="margin-bottom: 1.5rem;">
                    <h4 style="color: var(--color-primary); margin-bottom: 0.75rem;">How long does it take to get a
                        quotation?</h4>
                    <p style="color: var(--color-text-secondary); margin: 0;">
                        We typically respond to quotation requests within 24 hours. For urgent projects,
                        please call us directly for immediate assistance.
                    </p>
                </div>

                <div class="card" style="margin-bottom: 1.5rem;">
                    <h4 style="color: var(--color-primary); margin-bottom: 0.75rem;">Do you provide onsite
                        consultations?</h4>
                    <p style="color: var(--color-text-secondary); margin: 0;">
                        Yes! We offer free onsite consultations to better understand your requirements and
                        provide accurate quotations. This is especially helpful for custom projects.
                    </p>
                </div>

                <div class="card" style="margin-bottom: 1.5rem;">
                    <h4 style="color: var(--color-primary); margin-bottom: 0.75rem;">What is your minimum order or
                        project size?</h4>
                    <p style="color: var(--color-text-secondary); margin: 0;">
                        We handle projects of all sizes, from small repairs to large-scale fabrication.
                        No project is too small or too large for our team.
                    </p>
                </div>

                <div class="card" style="margin-bottom: 1.5rem;">
                    <h4 style="color: var(--color-primary); margin-bottom: 0.75rem;">Do you offer emergency repair
                        services?</h4>
                    <p style="color: var(--color-text-secondary); margin: 0;">
                        Yes, we provide emergency onsite repair services for urgent situations. Contact us
                        immediately and we'll dispatch our team as quickly as possible.
                    </p>
                </div>

                <div class="card">
                    <h4 style="color: var(--color-primary); margin-bottom: 0.75rem;">What payment methods do you accept?
                    </h4>
                    <p style="color: var(--color-text-secondary); margin: 0;">
                        We accept various payment methods including bank transfer, cheque, and cash.
                        Payment terms will be discussed during the quotation process.
                    </p>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <!-- SweetAlert2 CSS & JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            $('#contactForm').on('submit', function(e) {
                e.preventDefault(); // prevent default submission

                $('#submitButton').prop('disabled', true);
                $('#buttonText').hide();
                $('#buttonLoader').show();

                $.ajax({
                    url: $(this).attr('action'),
                    method: $(this).attr('method'),
                    data: $(this).serialize(),
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Message Sent!',
                            text: response.message,
                            confirmButtonColor: '#007bff' // primary color
                        });
                        $('#contactForm')[0].reset();
                    },
                    error: function(xhr) {
                        let errors = xhr.responseJSON?.errors;
                        let errorMessage = '';

                        if (errors) {
                            $.each(errors, function(key, value) {
                                errorMessage += value[0] + '\n';
                            });
                        } else {
                            errorMessage = xhr.responseJSON?.message ||
                                'Something went wrong. Please try again later.';
                        }

                        Swal.fire({
                            icon: 'error',
                            title: 'Oops!',
                            text: errorMessage,
                            confirmButtonColor: '#007bff' // primary color
                        });
                    },

                    complete: function() {
                        $('#submitButton').prop('disabled', false);
                        $('#buttonText').show();
                        $('#buttonLoader').hide();
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.website', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Alphinex Solutions\blueweldsg-royce\resources\views/website/contact.blade.php ENDPATH**/ ?>