@extends('layouts.website')

@section('title', 'Project Videos - BlueWeldSG')

@section('content')

    {{-- Hero Section --}}
    <section class="section-header-wrapper bg-light">
        <div class="container text-center" style="padding: 4rem 1rem;">
            <span class="section-badge"
                style="display:inline-block; padding: 0.5rem 1rem; background: #e0f2fe; color: #0284c7; border-radius: 50px; font-weight: 600; font-size: 0.875rem; margin-bottom: 1rem;">
                Our Portfolio
            </span>
            <h1 class="section-title" style="font-size: 2.5rem; color: #0f172a; font-weight: 800; margin-bottom: 1rem;">
                Featured Project Videos
            </h1>
            <p class="section-description" style="max-width: 600px; margin: 0 auto; color: #64748b; font-size: 1.125rem;">
                See our cold welding experts in action. From delicate repairs to large-scale fabrications,
                watch how we deliver quality results for commercial kitchens.
            </p>
        </div>
    </section>

    {{-- Video Gallery Section --}}
    <section class="section bg-white">
        <div class="container">
            @if ($videos->count() > 0)
                <div class="grid grid-2"
                    style="display: grid; grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); gap: 2rem;">
                    @foreach ($videos as $video)
                        <div class="card video-card"
                            style="overflow: hidden; border-radius: 12px; box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06); transition: transform 0.2s; border: 1px solid #e2e8f0; background: white;">
                            <div class="card-video-wrapper"
                                style="position: relative; padding-bottom: 56.25%; /* 16:9 */ height: 0; background: #000;">
                                @if($video->video_type === 'upload')
                                    <video controls
                                        style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;">
                                        <source src="{{ $video->embed_url }}" type="video/mp4">
                                        Your browser does not support the video tag.
                                    </video>
                                @else
                                    <iframe src="{{ $video->embed_url }}"
                                        style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; border:0;"
                                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                        allowfullscreen>
                                    </iframe>
                                @endif
                            </div>
                            @if ($video->title)
                                <div class="card-body" style="padding: 1.5rem;">
                                    <h3 class="card-title"
                                        style="font-size: 1.25rem; font-weight: 700; color: #1e293b; margin-bottom: 0;">
                                        {{ $video->title }}
                                    </h3>
                                </div>
                            @endif
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-5">
                    <div style="font-size: 3rem; color: #94a3b8; margin-bottom: 1rem;">
                        <i class="fas fa-film"></i>
                    </div>
                    <h3 style="color: #64748b;">No videos available yet.</h3>
                    <p style="color: #94a3b8;">Check back soon for updates!</p>
                </div>
            @endif
        </div>
    </section>

@endsection

@section('styles')
    <style>
        /* Additional custom styles if needed, ensuring consistency */
        .video-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
    </style>
@endsection
