@extends('layouts.website')

@section('title', 'Our Work - BlueWeldSG | Portfolio & Past Projects')

@section('content')

    <!-- Hero Section -->
    <section class="hero hero-with-image hero-projects">
        <div class="hero-background"></div>
        <div class="hero-overlay"></div>
        <div class="hero-container">
            <div class="hero-badge">Our Portfolio</div>
            <h1>See Our Work<br>In Action</h1>
            <p class="hero-subtitle">
                Explore our portfolio of completed projects showcasing precision cold welding,
                custom fabrication, and professional installations for commercial kitchens.
            </p>
        </div>
    </section>

    <!-- Services Overview Section -->
    <section class="section bg-white">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">What We Do</span>
                <h2 class="section-title">Our Expertise</h2>
            </div>

            <div class="grid grid-2">
                <!-- SS Trolleys -->
                <div class="card" style="overflow: hidden;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 0.5rem; margin-bottom: 1rem;">
                        <img src="{{ asset('images/trolley.jpg') }}" alt="SS Trolley 1"
                            class="expertise-image" style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                        <img src="{{ asset('images/trolley-2.jpg') }}" alt="SS Trolley 2"
                            class="expertise-image" style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                    </div>
                    <h3 class="card-title">SS Trolleys</h3>
                    <p class="card-text">
                        Custom-built stainless steel trolleys for commercial kitchens. Multiple tiers,
                        various sizes, and configurations to suit your workflow.
                    </p>
                </div>

                <!-- SS Shelving Units -->
                <div class="card" style="overflow: hidden;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 0.5rem; margin-bottom: 1rem;">
                        <img src="{{ asset('images/shelving.jpg') }}" alt="SS Shelving 1"
                            class="expertise-image" style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                        <img src="{{ asset('images/shelving-2.jpg') }}" alt="SS Shelving 2"
                            class="expertise-image" style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                    </div>
                    <h3 class="card-title">SS Shelving Units</h3>
                    <p class="card-text">
                        Durable shelving systems designed for heavy-duty commercial use. Adjustable,
                        hygienic, and built to last.
                    </p>
                </div>

                <!-- Equipment Repairs -->
                <div class="card" style="overflow: hidden;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 0.5rem; margin-bottom: 1rem;">
                        <img src="{{ asset('images/repairing.jpg') }}" alt="Equipment Repair 1"
                            class="expertise-image" style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                        <img src="{{ asset('images/repairing2.jpg') }}" alt="Equipment Repair 2"
                            class="expertise-image" style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                    </div>
                    <h3 class="card-title">Equipment Repairs</h3>
                    <p class="card-text">
                        Expert cold welding repairs on thin stainless steel equipment without heat
                        damage or warping.
                    </p>
                </div>

                <!-- Work Tables -->
                <div class="card" style="overflow: hidden;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 0.5rem; margin-bottom: 1rem;">
                        <img src="{{ asset('images/work-table-1.jpg') }}" alt="Work Table 1"
                            class="expertise-image" style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                        <img src="{{ asset('images/work-table-2.jpg') }}" alt="Work Table 2"
                            class="expertise-image" style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                    </div>
                    <h3 class="card-title">Work Tables</h3>
                    <p class="card-text">
                        Professional-grade work tables with integrated storage, sinks, and custom
                        features for your kitchen.
                    </p>
                </div>

                <!-- Hotel Solutions -->
                <div class="card" style="overflow: hidden;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 0.5rem; margin-bottom: 1rem;">
                        <img src="{{ asset('images/hotel-solution.jpg') }}" alt="Hotel Solution 1"
                            class="expertise-image" style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                        <img src="{{ asset('images/hotel-solution-2.jpg') }}" alt="Hotel Solution 2"
                            class="expertise-image" style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                    </div>
                    <h3 class="card-title">Hotel Solutions</h3>
                    <p class="card-text">
                        Specialized services for hotel kitchens, buffet stations, and commercial
                        food service areas.
                    </p>
                </div>

                <!-- Custom Fabrication -->
                <div class="card" style="overflow: hidden;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 0.5rem; margin-bottom: 1rem;">
                        <img src="{{ asset('images/fabrication-1.jpg') }}" alt="Custom Fabrication 1"
                            class="expertise-image" style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                        <img src="{{ asset('images/fabrication-2.png') }}" alt="Custom Fabrication 2"
                            class="expertise-image" style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                    </div>
                    <h3 class="card-title">Custom Fabrication</h3>
                    <p class="card-text">
                        Bespoke stainless steel solutions designed and built to your exact
                        specifications.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Videos Section -->
    <section class="section bg-light" id="videos">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Gallery</span>
                <h2 class="section-title">Project Videos</h2>
                <p class="section-description">
                    Watch our experts in action. From delicate repairs to large-scale fabrications.
                </p>
            </div>

            @if ($videos->count() > 0)
                {{-- Use auto-fill to prevent single items from stretching to full width --}}
                <div class="grid grid-3"
                    style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 2rem; margin-top: 3rem;">
                    @foreach ($videos as $video)
                        {{-- Removed 'video-card' class to avoid CSS conflict --}}
                        <div class="card"
                            style="overflow: hidden; border-radius: 12px; box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1); border: 1px solid #e2e8f0; background: white; padding: 0;">
                            <div
                                style="position: relative; padding-bottom: 56.25%; /* 16:9 */ height: 0; background: #000;">
                                <iframe src="{{ $video->embed_url }}"
                                    style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; border:0;"
                                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                    allowfullscreen title="{{ $video->title }}">
                                </iframe>
                            </div>
                            @if ($video->title)
                                <div class="card-body" style="padding: 1rem;">
                                    <h3
                                        style="font-size: 1.1rem; font-family: var(--font-heading); font-weight: 600; color: #1e293b; margin-bottom: 0;">
                                        {{ $video->title }}
                                    </h3>
                                </div>
                            @endif
                        </div>
                    @endforeach
                </div>
            @else
                <div class="card text-center" style="max-width: 600px; margin: 3rem auto 0;">
                    <h3 style="color: var(--color-primary); margin-bottom: 1rem;">📸 Coming Soon</h3>
                    <p class="card-text" style="margin-bottom: 1.5rem;">
                        We are currently updating our portfolio. Please check back soon!
                    </p>
                    <a href="{{ route('contact') }}" class="btn btn-primary">
                        Contact Us
                    </a>
                </div>
            @endif
        </div>
    </section>
    <!-- Project Stats Section -->
    <section class="section bg-white">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Our Track Record</span>
                <h2 class="section-title">By The Numbers</h2>
            </div>

            <div class="grid grid-2" style="margin-top: 3rem;">
                <div class="card text-center">
                    <div style="font-size: 3rem; font-weight: 700; color: var(--color-accent); margin-bottom: 0.5rem;">
                        100+</div>
                    <h4 style="color: var(--color-primary-dark); margin-bottom: 0.5rem;">Projects Completed</h4>
                    <p style="color: var(--color-text-secondary); margin: 0;">Successful installations and fabrications
                    </p>
                </div>

                <div class="card text-center">
                    <div style="font-size: 3rem; font-weight: 700; color: var(--color-accent); margin-bottom: 0.5rem;">
                        50+</div>
                    <h4 style="color: var(--color-primary-dark); margin-bottom: 0.5rem;">Satisfied Clients</h4>
                    <p style="color: var(--color-text-secondary); margin: 0;">Hotels, restaurants, and commercial
                        kitchens</p>
                </div>

                <div class="card text-center">
                    <div style="font-size: 3rem; font-weight: 700; color: var(--color-accent); margin-bottom: 0.5rem;">
                        1mm</div>
                    <h4 style="color: var(--color-primary-dark); margin-bottom: 0.5rem;">Minimum Thickness</h4>
                    <p style="color: var(--color-text-secondary); margin: 0;">Ultra-thin steel welding capability</p>
                </div>

                <div class="card text-center">
                    <div style="font-size: 3rem; font-weight: 700; color: var(--color-accent); margin-bottom: 0.5rem;">
                        24hrs</div>
                    <h4 style="color: var(--color-primary-dark); margin-bottom: 0.5rem;">Response Time</h4>
                    <p style="color: var(--color-text-secondary); margin: 0;">Quick quotations and emergency services
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section class="section bg-light">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Testimonials</span>
                <h2 class="section-title">What Our Clients Say</h2>
            </div>

            <div class="grid grid-3">
                <div class="card" style="position: relative;">
                    <div
                        style="position: absolute; top: 1.5rem; right: 1.5rem; color: var(--color-bg-light); font-size: 3rem; opacity: 0.3;">
                        <i class="fas fa-quote-right"></i>
                    </div>
                    <div style="color: #fbbf24; font-size: 1.25rem; margin-bottom: 1rem;">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p
                        style="color: var(--color-text-secondary); font-style: italic; margin-bottom: 1.5rem; line-height: 1.6;">
                        "Excellent cold welding service! They repaired our ultra-thin kitchen equipment perfectly.
                        No other company in Singapore could do this."
                    </p>
                    <div style="border-top: 2px solid var(--color-bg-light); padding-top: 1rem;">
                        <h5 style="color: var(--color-primary); margin: 0; font-weight: 600;">Hotel Manager</h5>
                        <p style="color: var(--color-text-secondary); font-size: 0.875rem; margin: 0.25rem 0 0 0;">5-Star
                            Hotel, Singapore</p>
                    </div>
                </div>

                <div class="card" style="position: relative;">
                    <div
                        style="position: absolute; top: 1.5rem; right: 1.5rem; color: var(--color-bg-light); font-size: 3rem; opacity: 0.3;">
                        <i class="fas fa-quote-right"></i>
                    </div>
                    <div style="color: #fbbf24; font-size: 1.25rem; margin-bottom: 1rem;">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p
                        style="color: var(--color-text-secondary); font-style: italic; margin-bottom: 1.5rem; line-height: 1.6;">
                        "Professional team, quality workmanship, and reasonable prices. The custom trolleys they
                        made for us are perfect for our kitchen workflow."
                    </p>
                    <div style="border-top: 2px solid var(--color-bg-light); padding-top: 1rem;">
                        <h5 style="color: var(--color-primary); margin: 0; font-weight: 600;">Restaurant Owner</h5>
                        <p style="color: var(--color-text-secondary); font-size: 0.875rem; margin: 0.25rem 0 0 0;">Fine
                            Dining Restaurant</p>
                    </div>
                </div>

                <div class="card" style="position: relative;">
                    <div
                        style="position: absolute; top: 1.5rem; right: 1.5rem; color: var(--color-bg-light); font-size: 3rem; opacity: 0.3;">
                        <i class="fas fa-quote-right"></i>
                    </div>
                    <div style="color: #fbbf24; font-size: 1.25rem; margin-bottom: 1rem;">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p
                        style="color: var(--color-text-secondary); font-style: italic; margin-bottom: 1.5rem; line-height: 1.6;">
                        "Fast onsite service saved us during a critical breakdown. They came immediately and
                        fixed our equipment on the spot. Highly recommended!"
                    </p>
                    <div style="border-top: 2px solid var(--color-bg-light); padding-top: 1rem;">
                        <h5 style="color: var(--color-primary); margin: 0; font-weight: 600;">Kitchen Manager</h5>
                        <p style="color: var(--color-text-secondary); font-size: 0.875rem; margin: 0.25rem 0 0 0;">Catering
                            Company</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- CTA Section -->
    <section class="section bg-white">
        <div class="container text-center">
            <h2 class="section-title">Ready to Start Your Project?</h2>
            <p class="section-description mb-4">
                Contact us today for a free quotation. We'll discuss your requirements and provide
                expert recommendations for your stainless steel needs.
            </p>
            <a href="{{ route('contact') }}" class="btn btn-primary">
                Get Free Quotation
                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.5 15L12.5 10L7.5 5" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </a>
        </div>
    </section>

    <!-- Image Lightbox Modal -->
    <div id="imageLightbox" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.95); z-index: 9999; align-items: center; justify-content: center; padding: 2rem;">
        <button id="closeLightbox" style="position: absolute; top: 2rem; right: 2rem; background: rgba(255,255,255,0.2); border: none; color: white; font-size: 2rem; width: 50px; height: 50px; border-radius: 50%; cursor: pointer; display: flex; align-items: center; justify-content: center; transition: background 0.3s; backdrop-filter: blur(10px);">
            <i class="fas fa-times"></i>
        </button>
        <img id="lightboxImage" src="" alt="" style="max-width: 90%; max-height: 90%; object-fit: contain; border-radius: 8px; box-shadow: 0 20px 60px rgba(0,0,0,0.5);">
    </div>

@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const expertiseImages = document.querySelectorAll('.expertise-image');
        const lightbox = document.getElementById('imageLightbox');
        const lightboxImage = document.getElementById('lightboxImage');
        const closeLightbox = document.getElementById('closeLightbox');

        // Add hover effect
        expertiseImages.forEach(img => {
            img.addEventListener('mouseenter', function() {
                this.style.transform = 'scale(1.05)';
                this.style.boxShadow = '0 8px 16px rgba(0,0,0,0.2)';
            });

            img.addEventListener('mouseleave', function() {
                this.style.transform = 'scale(1)';
                this.style.boxShadow = 'none';
            });

            // Click to open lightbox
            img.addEventListener('click', function() {
                lightboxImage.src = this.src;
                lightboxImage.alt = this.alt;
                lightbox.style.display = 'flex';
                document.body.style.overflow = 'hidden';
            });
        });

        // Close lightbox
        closeLightbox.addEventListener('click', function() {
            lightbox.style.display = 'none';
            document.body.style.overflow = 'auto';
        });

        // Close on background click
        lightbox.addEventListener('click', function(e) {
            if (e.target === lightbox) {
                lightbox.style.display = 'none';
                document.body.style.overflow = 'auto';
            }
        });

        // Close on ESC key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && lightbox.style.display === 'flex') {
                lightbox.style.display = 'none';
                document.body.style.overflow = 'auto';
            }
        });

        // Close button hover effect
        closeLightbox.addEventListener('mouseenter', function() {
            this.style.background = 'rgba(255,255,255,0.3)';
        });

        closeLightbox.addEventListener('mouseleave', function() {
            this.style.background = 'rgba(255,255,255,0.2)';
        });
    });
</script>
@endpush
