<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Contact Form Submission</title>
    <style>
        body {
            font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
            background-color: #f4f6f9;
            margin: 0;
            padding: 0;
            color: #333333;
            line-height: 1.6;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            margin-top: 40px;
            margin-bottom: 40px;
        }
        .header {
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
            color: #ffffff;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }
        .content {
            padding: 40px 30px;
        }
        .field-group {
            margin-bottom: 20px;
            border-bottom: 1px solid #f0f0f0;
            padding-bottom: 20px;
        }
        .field-group:last-child {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
        }
        .label {
            font-size: 12px;
            text-transform: uppercase;
            color: #64748b;
            font-weight: 600;
            margin-bottom: 5px;
            display: block;
            letter-spacing: 0.5px;
        }
        .value {
            font-size: 16px;
            color: #1e293b;
            font-weight: 500;
        }
        .message-box {
            background-color: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            padding: 15px;
            margin-top: 5px;
            white-space: pre-wrap;
        }
        .footer {
            background-color: #f8fafc;
            padding: 20px;
            text-align: center;
            font-size: 12px;
            color: #94a3b8;
            border-top: 1px solid #e2e8f0;
        }
        @media only screen and (max-width: 600px) {
            .container {
                width: 100% !important;
                margin-top: 0 !important;
                margin-bottom: 0 !important;
                border-radius: 0 !important;
                box-shadow: none !important;
            }
            .content {
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>New Contact Inquiry</h1>
        </div>
        <div class="content">
            <div class="field-group">
                <span class="label">Name</span>
                <div class="value">{{ $data['name'] }}</div>
            </div>

            <div class="field-group">
                <span class="label">Email</span>
                <div class="value">
                    <a href="mailto:{{ $data['email'] }}" style="color: #2563eb; text-decoration: none;">
                        {{ $data['email'] }}
                    </a>
                </div>
            </div>

            <div class="field-group">
                <span class="label">Phone</span>
                <div class="value">{{ $data['phone'] ?? 'N/A' }}</div>
            </div>

            <div class="field-group">
                <span class="label">Service Required</span>
                <div class="value">{{ $data['service'] ?? 'Not Specified' }}</div>
            </div>

            <div class="field-group">
                <span class="label">Message</span>
                <div class="value message-box">{{ $data['message'] }}</div>
            </div>
        </div>
        <div class="footer">
            <p>This email was sent from the Contact Us form on BlueWeldSG.</p>
            <p>&copy; {{ date('Y') }} BlueWeldSG. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
