@extends('layouts.admin')
@section('content')
    <!-- Enhanced Header Section -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <div class="d-flex align-items-center">
                <div class="mr-3">
                    <i class="fas fa-user-shield text-primary" style="font-size: 2rem;"></i>
                </div>
                <div>
                    <h2 class="mb-0 text-dark font-weight-bold">
                        {{ trans('cruds.role.title_singular') }} {{ trans('global.list') }}
                    </h2>
                    <p class="text-muted mb-0">Total Roles: {{ $roles->count() }}</p>
                </div>
            </div>
        </div>
        <div class="col-lg-4 text-right">
            @can('role_create')
                <a class="btn btn-primary btn-lg shadow-sm" href="{{ route('admin.roles.create') }}">
                    <i class="fas fa-plus-circle mr-2"></i>
                    {{ trans('global.add') }} {{ trans('cruds.role.title_singular') }}
                </a>
            @endcan
        </div>
    </div>

    <!-- Modern Styled Card -->
    <div class="card shadow-sm border-0">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover datatable datatable-Role align-middle">
                    <thead class="thead-light">
                        <tr>
                            <th width="10"></th>
                            <th>S.No</th>
                            <th>{{ trans('cruds.role.fields.title') }}</th>
                            <th>Users</th>
                            <th>Permissions</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($roles as $key => $role)
                            <tr data-entry-id="{{ $role->id }}">
                                <td></td>
                                <td>{{ $loop->iteration }}</td>
                                <td>
                                    <strong class="text-dark">{{ $role->title ?? '' }}</strong>
                                </td>
                                <td>
                                    @php
                                        $userCount = \App\Models\User::where('role_id', $role->id)->count();
                                    @endphp
                                    <span class="badge badge-pill badge-secondary" title="Users with this role">
                                        {{ $userCount }} {{ Str::plural('User', $userCount) }}
                                    </span>
                                </td>
                                <td>
                                    <span class="badge badge-info" title="Permissions assigned">
                                        {{ $role->permissions->count() }} Assigned
                                    </span>
                                </td>
                                <td>
                                    <div class="action-buttons">
                                        @can('role_show')
                                            <a class="action-btn action-btn-view"
                                                href="{{ route('admin.roles.show', $role->id) }}" title="View Role">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        @endcan

                                        @can('role_edit')
                                            <a class="action-btn action-btn-edit"
                                                href="{{ route('admin.roles.edit', $role->id) }}" title="Edit Role">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        @endcan

                                        @can('role_delete')
                                            <button type="button" class="action-btn action-btn-delete"
                                                data-delete-url="{{ route('admin.roles.destroy', $role->id) }}"
                                                data-delete-message="Are you sure you want to delete this role? This will also remove all user assignments."
                                                title="Delete Role">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Include Delete Confirmation Modal -->
    @include('partials.deleteConfirmationModal')
@endsection

@section('scripts')
    @parent
    <script src="{{ asset('js/deleteConfirmationModal.js') }}"></script>

    <script>
        $(function() {
            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)

            @can('role_delete')
                let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
                let deleteButton = {
                    text: deleteButtonTrans,
                    url: "{{ route('admin.roles.massDestroy') }}",
                    className: 'btn-danger',
                    action: function(e, dt, node, config) {
                        var ids = $.map(dt.rows({
                            selected: true
                        }).nodes(), function(entry) {
                            return $(entry).data('entry-id')
                        });

                        if (ids.length === 0) {
                            alert('{{ trans('global.datatables.zero_selected') }}')
                            return
                        }

                        if (confirm('{{ trans('global.areYouSure') }}')) {
                            $.ajax({
                                headers: {
                                    'x-csrf-token': _token
                                },
                                method: 'POST',
                                url: config.url,
                                data: {
                                    ids: ids,
                                    _method: 'DELETE'
                                }
                            }).done(function() {
                                location.reload()
                            })
                        }
                    }
                }
                dtButtons.push(deleteButton)
            @endcan

            $.extend(true, $.fn.dataTable.defaults, {
                orderCellsTop: true,
                order: [
                    [1, 'asc']
                ],
                pageLength: 50,
            });

            let table = $('.datatable-Role:not(.ajaxTable)').DataTable({
                buttons: dtButtons
            })

            $('a[data-toggle="tab"]').on('shown.bs.tab click', function(e) {
                $($.fn.dataTable.tables(true)).DataTable().columns.adjust();
            });
        });
    </script>
@endsection
