@extends('layouts.admin')
@section('content')
    <style>
        .form-check-input[type="checkbox"] {
            width: 2.5em;
            height: 1.3em;
            border-radius: 1em;
            background-color: #ccc;
            position: relative;
            appearance: none;
            cursor: pointer;
            transition: background-color 0.2s ease-in-out;
        }

        .form-check-input[type="checkbox"]::before {
            content: "";
            position: absolute;
            top: 0.15em;
            left: 0.15em;
            width: 1em;
            height: 1em;
            border-radius: 50%;
            background: white;
            transition: transform 0.2s ease-in-out;
        }

        .form-check-input[type="checkbox"]:checked {
            background-color: #4CAF50;
        }

        .form-check-input[type="checkbox"]:checked::before {
            transform: translateX(1.2em);
        }
    </style>

    <!-- Header -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <div class="d-flex align-items-center">
                <div class="mr-3">
                    <i class="fas fa-user-shield text-primary" style="font-size: 2rem;"></i>
                </div>
                <div>
                    <h2 class="mb-0 text-dark font-weight-bold">{{ trans('global.edit') }}
                        {{ trans('cruds.role.title_singular') }}</h2>
                    <p class="text-muted mb-0">Update role information and assigned permissions</p>
                </div>
            </div>
        </div>
        <div class="col-lg-4 text-right">
            <a href="{{ route('admin.roles.index') }}" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left mr-2"></i>Back to Roles
            </a>
        </div>
    </div>

    <!-- Role Edit Card -->
    <div class="card shadow-sm border-0">
        <div class="card-header bg-white border-0 d-flex align-items-center justify-content-between">
            <div class="d-flex align-items-center">
                <i class="fas fa-id-badge text-primary mr-2"></i>
                <h5 class="mb-0 font-weight-bold">Edit Role Information</h5>
            </div>
            <div>
                <button type="button" class="btn btn-sm btn-outline-success mr-2" id="selectAllModules">
                    <i class="fas fa-check-double mr-1"></i>Select All
                </button>
                <button type="button" class="btn btn-sm btn-outline-danger" id="deselectAllModules">
                    <i class="fas fa-times mr-1"></i>Deselect All
                </button>
            </div>
        </div>

        <div class="card-body">
            <form method="POST" action="{{ route('admin.roles.update', $role->id) }}" enctype="multipart/form-data"
                class="needs-validation" novalidate>
                @csrf
                @method('PATCH')

                <!-- Role Title -->
                <div class="form-group">
                    <label class="required" for="title">{{ trans('cruds.role.fields.title') }}</label>
                    <input class="form-control {{ $errors->has('title') ? 'is-invalid' : '' }}" type="text"
                        name="title" id="title" value="{{ old('title', $role->title) }}" required>
                    @if ($errors->has('title'))
                        <span class="text-danger">{{ $errors->first('title') }}</span>
                    @endif
                    <span class="help-block">{{ trans('cruds.role.fields.title_helper') }}</span>
                </div>

                <!-- Permissions grouped by module -->
                <div class="mt-4 container-fluid">
                    <div class="row">
                        @foreach ($permissions as $module => $modulePermissions)
                            @php
                                $moduleName = $module ?: 'General';
                                $allChecked =
                                    $modulePermissions->every(fn($perm) => $role->permissions->contains($perm->id)) &&
                                    count($modulePermissions) > 0;
                            @endphp

                            <div class="col-lg-4 col-md-6 col-sm-12 mb-4 d-flex">
                                <div class="card border rounded shadow-sm w-100">
                                    <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                        <h6 class="mb-0 text-capitalize font-weight-bold">
                                            <i class="fas fa-folder-open text-primary mr-2"></i>
                                            {{ ucfirst($moduleName) }} Module
                                        </h6>
                                        <div class="form-check form-switch">
                                            <input class="form-check-input module-toggle" type="checkbox"
                                                data-module="{{ $moduleName }}" {{ $allChecked ? 'checked' : '' }}>
                                            <label class="form-check-label small text-muted">All</label>
                                        </div>
                                    </div>

                                    <div class="card-body py-3">
                                        @foreach ($modulePermissions as $perm)
                                            <div class="form-check mb-2">
                                                <input class="form-check-input permission-checkbox" type="checkbox"
                                                    name="permissions[]" value="{{ $perm->id }}"
                                                    data-module="{{ $moduleName }}" id="permission-{{ $perm->id }}"
                                                    {{ $role->permissions->contains($perm->id) ? 'checked' : '' }}>

                                                <label class="form-check-label" for="permission-{{ $perm->id }}">
                                                    {{ ucwords(str_replace('_', ' ', str_replace($module . '_', '', $perm->title))) }}
                                                </label>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Form Actions -->
                <div class="form-group mt-4 pt-3 border-top">
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.roles.index') }}" class="btn btn-outline-secondary btn-lg shadow-sm mb-2">
                            <i class="fas fa-times mr-2"></i>Cancel
                        </a>
                        <button class="btn btn-primary btn-lg shadow-sm" type="submit">
                            <i class="fas fa-save mr-2"></i>{{ trans('global.update') }}
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(function() {
            // Toggle all permissions within a module card
            $('.module-toggle').on('change', function() {
                const module = $(this).data('module');
                const checked = $(this).is(':checked');
                $(`.permission-checkbox[data-module="${module}"]`).prop('checked', checked);
            });

            // Update module toggle when individual permission changes
            $('.permission-checkbox').on('change', function() {
                const module = $(this).data('module');
                const total = $(`.permission-checkbox[data-module="${module}"]`).length;
                const checked = $(`.permission-checkbox[data-module="${module}"]:checked`).length;
                $(`.module-toggle[data-module="${module}"]`).prop('checked', total === checked);
            });

            // Select all
            $('#selectAllModules').on('click', function() {
                $('.permission-checkbox, .module-toggle').prop('checked', true);
            });

            // Deselect all
            $('#deselectAllModules').on('click', function() {
                $('.permission-checkbox, .module-toggle').prop('checked', false);
            });
        });
    </script>
@endsection
