@extends('layouts.admin')

@section('content')
    <style>
        .form-check-input[type="checkbox"] {
            width: 2.5em;
            height: 1.3em;
            border-radius: 1em;
            background-color: #ccc;
            position: relative;
            appearance: none;
            cursor: pointer;
            transition: background-color 0.2s ease-in-out;
        }

        .form-check-input[type="checkbox"]::before {
            content: "";
            position: absolute;
            top: 0.15em;
            left: 0.15em;
            width: 1em;
            height: 1em;
            border-radius: 50%;
            background: white;
            transition: transform 0.2s ease-in-out;
        }

        .form-check-input[type="checkbox"]:checked {
            background-color: #4CAF50;
        }

        .form-check-input[type="checkbox"]:checked::before {
            transform: translateX(1.2em);
        }
    </style>

    <div class="row mb-4">
        <div class="col-lg-8">
            <div class="d-flex align-items-center">
                <div class="mr-3">
                    <i class="fas fa-user-shield text-success" style="font-size: 2rem;"></i>
                </div>
                <div>
                    <h2 class="mb-0 text-dark font-weight-bold">
                        {{ trans('global.create') }} {{ trans('cruds.role.title_singular') }}
                    </h2>
                    <p class="text-muted mb-0">Define a new role and manage module-based permissions</p>
                </div>
            </div>
        </div>
        <div class="col-lg-4 text-right">
            <a href="{{ route('admin.roles.index') }}" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left mr-2"></i>Back to Roles
            </a>
        </div>
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-header bg-white border-0 d-flex align-items-center justify-content-between">
            <div class="d-flex align-items-center">
                <i class="fas fa-id-badge text-primary mr-2"></i>
                <h5 class="mb-0 font-weight-bold">Role Information</h5>
            </div>
            <div>
                <button type="button" class="btn btn-sm btn-outline-success mr-2" id="selectAllModules">
                    <i class="fas fa-check-double mr-1"></i>Select All
                </button>
                <button type="button" class="btn btn-sm btn-outline-danger" id="deselectAllModules">
                    <i class="fas fa-times mr-1"></i>Deselect All
                </button>
            </div>
        </div>

        <div class="card-body">
            <form method="POST" action="{{ route('admin.roles.store') }}" enctype="multipart/form-data"
                class="needs-validation" novalidate>
                @csrf

                <div class="form-group">
                    <label class="required" for="title">{{ trans('cruds.role.fields.title') }}</label>
                    <input class="form-control {{ $errors->has('title') ? 'is-invalid' : '' }}" type="text"
                        name="title" id="title" value="{{ old('title', '') }}" required>
                    @if ($errors->has('title'))
                        <span class="text-danger">{{ $errors->first('title') }}</span>
                    @endif
                </div>

                <div class="mt-4 container-fluid">
                    <div class="row">
                        @foreach ($permissions as $module => $modulePermissions)
                            <div class="col-lg-4 col-md-6 col-sm-12 mb-4 d-flex">
                                <div class="card border rounded shadow-sm w-100">
                                    <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                        <h6 class="mb-0 text-capitalize font-weight-bold">
                                            <i class="fas fa-folder-open text-primary mr-2"></i>{{ $module }} Module
                                        </h6>
                                        <div class="form-check form-switch">
                                            <input class="form-check-input module-toggle" type="checkbox"
                                                id="toggle-{{ $module }}" data-module="{{ $module }}">
                                            <label class="form-check-label small text-muted"
                                                for="toggle-{{ $module }}">All</label>
                                        </div>
                                    </div>

                                    <div class="card-body py-3">
                                        @foreach ($modulePermissions as $perm)
                                            @php
                                                // Clean label (remove underscores and module prefix)
                                                $label = str_replace(
                                                    '_',
                                                    ' ',
                                                    str_replace(
                                                        strtolower($module) . '_',
                                                        '',
                                                        strtolower($perm->title),
                                                    ),
                                                );
                                            @endphp
                                            <div class="form-check mb-2">
                                                <input class="form-check-input permission-checkbox" type="checkbox"
                                                    name="permissions[]" value="{{ $perm->id }}"
                                                    id="permission-{{ $perm->id }}" data-module="{{ $module }}">
                                                <label class="form-check-label" for="permission-{{ $perm->id }}">
                                                    {{ ucwords($label) }}
                                                </label>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <div class="form-group mt-4 pt-3 border-top">
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.roles.index') }}" class="btn btn-outline-secondary btn-lg shadow-sm mb-2">
                            <i class="fas fa-times mr-2"></i>Cancel
                        </a>
                        <button class="btn btn-primary btn-lg shadow-sm" type="submit">
                            <i class="fas fa-save mr-2"></i>{{ trans('global.save') }}
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(function() {
            // Toggle all permissions within a module
            $('.module-toggle').on('change', function() {
                const module = $(this).data('module');
                const checked = $(this).is(':checked');
                $(`.permission-checkbox[data-module="${module}"]`).prop('checked', checked);
            });

            // Update module toggle based on individual permission selections
            $('.permission-checkbox').on('change', function() {
                const module = $(this).data('module');
                const total = $(`.permission-checkbox[data-module="${module}"]`).length;
                const checked = $(`.permission-checkbox[data-module="${module}"]:checked`).length;
                $(`.module-toggle[data-module="${module}"]`).prop('checked', total === checked);
            });

            // Select all
            $('#selectAllModules').on('click', function() {
                $('.permission-checkbox, .module-toggle').prop('checked', true);
            });

            // Deselect all
            $('#deselectAllModules').on('click', function() {
                $('.permission-checkbox, .module-toggle').prop('checked', false);
            });
        });
    </script>
@endsection
