<?php

use App\Services\SettingsService;

if (!function_exists('setting')) {
    /**
     * Get a setting value
     */
    function setting($key, $default = null)
    {
        return SettingsService::get($key, $default);
    }
}

if (!function_exists('app_name')) {
    /**
     * Get the application name
     */
    function app_name()
    {
        return SettingsService::getAppName();
    }
}

if (!function_exists('app_logo')) {
    /**
     * Get the application logo URL
     */
    function app_logo()
    {
        return SettingsService::getLogoUrl();
    }
}

if (!function_exists('app_address')) {
    /**
     * Get the application address
     */
    function app_address()
    {
        return SettingsService::getAddress();
    }
}

if (!function_exists('app_symbol')) {
    /**
     * Get the application symbol
     */
    function app_symbol()
    {
        return SettingsService::getSymbol();
    }
}

if (!function_exists('format_currency')) {
    function format_currency($amount, $decimals = 2)
    {
        // get currency symbol from settings table
        $settings = \App\Models\Setting::getSettings();
        $symbol = $settings->currency_symbol ?? '$';

        // format the number
        $formatted = number_format((float)$amount, $decimals);

        return $symbol . ' ' . $formatted;
    }
}
