<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = [
        'app_name',
        'logo',
        'address',
        'currency_symbol',
    ];

    /**
     * Get the first settings record or create one if none exists
     */
    public static function getSettings()
    {
        return static::first() ?? static::create([
            'app_name' => 'BlueWeld SG',
            'logo' => null,
            'address' => null,
            'currency_symbol' => '$',
        ]);
    }

    /**
     * Get a specific setting value
     */
    public static function get($key, $default = null)
    {
        $settings = static::getSettings();
        return $settings->$key ?? $default;
    }

    /**
     * Update a specific setting value
     */
    public static function set($key, $value)
    {
        $settings = static::getSettings();
        $settings->update([$key => $value]);
        return $settings;
    }
}
